<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeRoom2 extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-room-2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - Room Widget 2', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'Room 2', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_room',
			[
				'label' => esc_html__( 'Room Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'room_select',
			[
				'label'     => esc_html__( 'Room Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'White Background', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Black Background', 'bdevs-elementor' ),
				],
				'default'   => '1',
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'booking_button',
			[
				'label'       => __( 'Booking Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Booking Button', 'bdevs-elementor' ),
				'default'     => __( 'Book Now', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'detail_button',
			[
				'label'       => __( 'Detail Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Detail Button', 'bdevs-elementor' ),
				'default'     => __( 'Details', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
            'post_number',
            [
                'label'       => __( 'Post Number', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Post Number', 'bdevs-elementor' ),
                'default'     => __( '4', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
                    'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
                ],
                'default'   => 'asc',
            ]
        );

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		
		$this->add_control(
			'show_booking_button',
			[
				'label'   => esc_html__( 'Show Booking Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		
		$this->add_control(
			'show_detail_button',
			[
				'label'   => esc_html__( 'Show Details Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if( wp_kses_post($settings['room_select']) == '1'): ?>
		<section class="rooms2 section-padding bg-cream" data-scroll-index="1">
		<?php elseif( wp_kses_post($settings['room_select']) == '2'): ?>
		<section class="rooms2 section-padding bg-black" data-scroll-index="1">
		<?php endif; ?> 
		    <div class="container">
		        <div class="row">
		            <div class="col-md-12">
		                <?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
						<div class="section-subtitle"><?php echo wp_kses_post($settings['sub_heading']); ?></div>
						<?php endif; ?>
						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
						<div class="section-title"><?php echo wp_kses_post($settings['heading']); ?></div>
						<?php endif; ?>
		            </div>
		        </div>
		        <div class="row">
		            <div class="col-md-12">
		                <div class="owl-carousel owl-theme">
		                	<?php $i = 0;
		                	$order = $settings['post_order'];
		                	$post_number = $settings['post_number'];
		                	$wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'room',  'orderby' => 'ID', 'order' => $order));

		                	while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
		                		$room_price = get_post_meta(get_the_ID(),'_cmb_room_price', true);   
		                		$room_img_2 = get_post_meta(get_the_ID(),'_cmb_room_img_2', true); 
		                		$room_facilities_2 = get_post_meta(get_the_ID(),'_cmb_room_facilities_2', true); 
		                		$i++;  
		                		?>
		                        <?php if($i % 2 == 1){ ?>
		                            <div class="rooms2">
		                                <figure><img src="<?php echo wp_get_attachment_url($room_img_2);?>" alt="" class="img-fluid"></figure>
		                                <div class="caption padding-left">
		                                    <h3><?php echo esc_attr($room_price); ?></h3>
		                                    <h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
		                                    <p><?php if(isset($thecappa_redux_demo['room_excerpt'])){?>
		                                        <?php echo esc_attr(thecappa_excerpt_2($thecappa_redux_demo['room_excerpt'])); ?>
		                                    <?php }else{?>
		                                        <?php echo esc_attr(thecappa_excerpt_2(15)); }?></p>
		                                    <div class="row room-facilities facilities-col-3">
		                                    	<div class="col-md-12">
		                                    		<ul>
				                                        <?php echo htmlspecialchars_decode(esc_attr($room_facilities_2));?>
				                                    </ul>
			                                    </div>
		                                    </div>
		                                    <hr class="border-2">
		                                    <div class="info-wrapper">
												<?php if (( '' !== $settings['detail_button'] ) && ( $settings['show_detail_button'] )): ?>
		                                        <div class="more"><a href="<?php the_permalink();?>" class="link-btn" tabindex="0"><?php echo wp_kses_post($settings['detail_button']); ?> <i class="ti-arrow-right"></i></a></div>
												<?php endif; ?>
		                                        <?php if (( '' !== $settings['booking_button'] ) && ( $settings['show_booking_button'] )): ?>
												<div class="butn-dark"> <a href="<?php the_permalink();?>"><span><?php echo wp_kses_post($settings['booking_button']); ?></span></a> </div>
												<?php endif; ?>
		                                    </div>
		                                </div>
		                            </div>
		                        <?php }elseif($i % 2 == 0){ ?>
		                            <div class="rooms2 left">
		                                <figure><img src="<?php echo wp_get_attachment_url($room_img_2);?>" alt="" class="img-fluid"></figure>
		                                <div class="caption padding-left">
		                                    <h3><?php echo esc_attr($room_price); ?></h3>
		                                    <h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
		                                    <p><?php if(isset($thecappa_redux_demo['room_excerpt'])){?>
		                                        <?php echo esc_attr(thecappa_excerpt_2($thecappa_redux_demo['room_excerpt'])); ?>
		                                    <?php }else{?>
		                                        <?php echo esc_attr(thecappa_excerpt_2(15)); }?></p>
		                                    <div class="row room-facilities facilities-col-3">
		                                        <div class="col-md-12">
			                                        <ul>
			                                        	<?php echo htmlspecialchars_decode(esc_attr($room_facilities_2));?>
			                                        </ul>
			                                    </div>
		                                    </div>
		                                    <hr class="border-2">
		                                    <div class="info-wrapper">
		                                        <?php if (( '' !== $settings['detail_button'] ) && ( $settings['show_detail_button'] )): ?>
		                                        <div class="more"><a href="<?php the_permalink();?>" class="link-btn" tabindex="0"><?php echo wp_kses_post($settings['detail_button']); ?> <i class="ti-arrow-right"></i></a></div>
												<?php endif; ?>
		                                        <?php if (( '' !== $settings['booking_button'] ) && ( $settings['show_booking_button'] )): ?>
												<div class="butn-dark"> <a href="<?php the_permalink();?>"><span><?php echo wp_kses_post($settings['booking_button']); ?></span></a> </div>
												<?php endif; ?>
		                                    </div>
		                                </div>
		                            </div>
		                        <?php } ?>
		                    <?php endwhile; ?>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>

		<?php if (is_admin())
		{ ?>
			<script type="text/javascript">
				$('.rooms2 .owl-carousel').owlCarousel({
					loop: true,
					margin: 30,
					mouseDrag: true,
					autoplay: false,
					dots: true,
					autoplayHoverPause: true,
					nav: false,
					navText: ["<span class='lnr ti-angle-left'></span>","<span class='lnr ti-angle-right'></span>"],
					responsiveClass: true,
					responsive: {
						0: {
							items: 1,
						},
						600: {
							items: 1
						},
						1000: {
							items: 1
						}
					}
				});
				
			</script>
		<?php }  ?>

	<?php
	}

}
