<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<?php $thecappa_redux_demo = get_option('redux_demo'); ?>

<head>

    <!-- Meta Tags -->

    <meta charset="<?php bloginfo( 'charset' ); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {?>

        <?php if(isset($thecappa_redux_demo['favicon']['url'])){?>

            <link rel="shortcut icon" href="<?php echo esc_url($thecappa_redux_demo['favicon']['url']); ?>">

        <?php } ?>

    <?php } ?>

    <?php wp_head(); ?> 


</head>

<body <?php body_class(); ?>>

    <div class="preloader-bg"></div>
    <div id="preloader">
        <div id="preloader-status">
            <div class="preloader-position loader"> <span></span> </div>
        </div>
    </div>
    <!-- Progress scroll totop -->
    <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Menu -->
    <div class="cappa-wrap">
        <div class="cappa-wrap-inner">
            <nav class="cappa-menu">
                <?php 
                wp_nav_menu( 
                    array( 
                        'theme_location' => 'toggle-2',
                        'container' => '',
                        'menu_class' => '', 
                        'menu_id' => '',
                        'menu'            => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'echo'            => true,
                        'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                        'walker'            => new thecappa_wp_bootstrap_navwalker_3(),
                        'before'          => '',
                        'after'           => '',
                        'link_before'     => '',
                        'link_after'      => '',
                        'items_wrap'      => '<ul class="%2$s">%3$s</ul>',
                        'depth'           => 0,        
                    )
                ); ?>
            </nav>
            <div class="cappa-menu-footer">
                <div class="reservation">
                    <?php if(isset($thecappa_redux_demo['phone_number']) && $thecappa_redux_demo['phone_number'] != ''){?>
                    <a href="<?php echo esc_attr($thecappa_redux_demo['phone_number']); ?>">
                        <?php }else{?>
                    <a href="tel:8551004444">
                        <?php } ?>
                        <?php if(isset($thecappa_redux_demo['reservation_icon_toggle']) && $thecappa_redux_demo['reservation_icon_toggle'] != ''){?>
                        <div class="icon d-flex justify-content-center align-items-center">
                            <i class="<?php echo esc_attr($thecappa_redux_demo['reservation_icon_toggle']); ?>"></i>
                        </div>
                        <?php }else{?>
                        <div class="icon d-flex justify-content-center align-items-center">
                            <i class="flaticon-call"></i>
                        </div>
                        <?php } ?>
                        <?php if(isset($thecappa_redux_demo['reservation_text_toggle']) && $thecappa_redux_demo['reservation_text_toggle'] != ''){?>
                        <div class="call"><?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['reservation_text_toggle']));?></div>
                        <?php }else{?>
                        <div class="call"><?php echo esc_html__( 'Reservation', 'thecappa' )?><br><span><?php echo esc_html__( '855 100 4444', 'thecappa' )?></span></div>
                        <?php } ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- Logo & Menu Burger -->
    <header class="cappa-header">
        <div class="container">
            <div class="row align-items-center">
                <!-- Logo -->
                <?php if(isset($thecappa_redux_demo['logo']['url']) && $thecappa_redux_demo['logo']['url'] != ''){?>
                    <div class="col-6 col-md-6 cappa-logo-wrap logo-default">
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="cappa-logo"><img src="<?php echo esc_url($thecappa_redux_demo['logo']['url']); ?>" alt=""></a>
                    </div>
                <?php }else{?>
                    <div class="col-6 col-md-6 cappa-logo-wrap logo-default">
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="cappa-logo"><img src="<?php echo get_template_directory_uri();?>/assets/img/logo.png" alt=""></a>
                    </div>
                <?php } ?>
                <?php if(isset($thecappa_redux_demo['logo_dark']['url']) && $thecappa_redux_demo['logo_dark']['url'] != ''){?>
                    <div class="col-6 col-md-6 cappa-logo-wrap logo-sticky">
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="cappa-logo"><img src="<?php echo esc_url($thecappa_redux_demo['logo_dark']['url']); ?>" alt=""></a>
                    </div>
                <?php }else{?>
                    <div class="col-6 col-md-6 cappa-logo-wrap logo-sticky">
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="cappa-logo"><img src="<?php echo get_template_directory_uri();?>/assets/img/logo-dark.png" alt=""></a>
                    </div>
                <?php } ?>
                <!-- Menu Burger -->
                <div class="col-6 col-md-6 text-right cappa-wrap-burger-wrap"> <a href="#" class="cappa-nav-toggle cappa-js-cappa-nav-toggle"><i></i></a> </div>
            </div>
        </div>
    </header>