<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeGridSlider extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-grid-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home Grid - Slider Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-grid' ];
	}

	public function get_keywords() {
		return [ 'Slider', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__( 'Slider Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'slider_select',
			[
				'label'     => esc_html__( 'Slider Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'Type 1', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Type 2', 'bdevs-elementor' ),
				],
				'default'   => '2',
			]
		);	

		$this->add_control(
			'booking_link',
			[
				'label'       => __( 'Search Room Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter link to Search Room', 'bdevs-elementor' ),
				'default'     => __( 'It is Booking Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Slider Images', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'image_select',
						'label'     => esc_html__( 'Image Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( 'Active', 'bdevs-elementor' ),
							'2'  => esc_html__( 'Inactive', 'bdevs-elementor' ),
						],
						'default'   => '2',
					],	
				    [
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Tab Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),
					],	
				],
			]
		);

		$this->add_control(
			'tabs_2',
			[
				'label' => esc_html__( 'Slider Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
				    [
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_link',
						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '#' , 'bdevs-elementor' ),
					],
					[
						'name'       => 'tab_book',
						'label'      => esc_html__( 'Book Button', 'bdevs-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'     => esc_html__( 'Book' , 'bdevs-elementor' ),
					],	
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_booking_form',
			[
				'label'   => esc_html__( 'Show Booking Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_arrow_down',
			[
				'label'   => esc_html__( 'Show Arrow Down', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if(wp_kses_post($settings['slider_select'])=='1') { ?>
		<div class="slider-grid-bg">
			<?php foreach ( $settings['tabs'] as $item ) : ?>
				<?php if( wp_kses_post($item['image_select']) == '1'): ?>
					<?php if ( '' !== $item['tab_image']['url'] ) : ?>
						<div style="background-image: url('<?php echo wp_kses_post($item['tab_image']['url']); ?>')" class="grid-img grid-img-active"></div>
					<?php endif; ?>
				<?php elseif( wp_kses_post($item['image_select']) == '2'): ?>
					<?php if ( '' !== $item['tab_image']['url'] ) : ?>
						<div style="background-image: url('<?php echo wp_kses_post($item['tab_image']['url']); ?>')" class="grid-img"></div>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>
			<div class="content container">
				<div class="row">
					<div class="col-md-12">
						<div class="owl-carousel owl-theme">
							<?php foreach ( $settings['tabs_2'] as $item ) : ?>
								<div class="grid-item">
									<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="grid-con">
										<?php if ( '' !== $item['tab_book'] ) : ?>
											<span class="book"><?php echo wp_kses_post($item['tab_book']); ?></span>
										<?php endif; ?>
										<span class="subtitle-title">
											<?php if ( '' !== $item['tab_subtitle'] ) : ?>
												<span class="subtitle"><?php echo wp_kses_post($item['tab_subtitle']); ?></span>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_title'] ) : ?>
												<span class="title"><?php echo wp_kses_post($item['tab_title']); ?></span>
											<?php endif; ?>
										</span>
									</a>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Booking Search -->
		<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
		<div class="booking-wrapper">
            <div class="container">
                <div class="booking-inner clearfix">
                    <form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                        <div class="col1 c1">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in">
                                </div>
                            </div>
                        </div>
                        <div class="col1 c2">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out">
                                </div>
                            </div>
                        </div>
                        <div class="col2 c3">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="adult_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Adult', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Adults', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Adults', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Adults', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c4">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="children_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c5">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Rooms', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Room', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Rooms', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Rooms', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Rooms', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col3 c6">
                            <button type="submit" class="btn-form1-submit"><?php echo esc_html__( 'Check Now', 'thecappa' )?></button>
                        </div>
                    </form>
                </div>
            </div>
    	</div>
    	
		<?php endif; ?>

		<?php } elseif(wp_kses_post($settings['slider_select'])=='2') { ?>

			<div class="slider-grid-bg">
				<?php foreach ( $settings['tabs'] as $item ) : ?>
					<?php if( wp_kses_post($item['image_select']) == '1'): ?>
						<?php if ( '' !== $item['tab_image']['url'] ) : ?>
							<div style="background-image: url('<?php echo wp_kses_post($item['tab_image']['url']); ?>')" class="grid-img grid-img-active"></div>
						<?php endif; ?>
					<?php elseif( wp_kses_post($item['image_select']) == '2'): ?>
						<?php if ( '' !== $item['tab_image']['url'] ) : ?>
							<div style="background-image: url('<?php echo wp_kses_post($item['tab_image']['url']); ?>')" class="grid-img"></div>
						<?php endif; ?>
					<?php endif; ?>
				<?php endforeach; ?>
				<div class="content container">
					<div class="row">
						<div class="col-md-12">
							<div class="owl-carousel owl-theme">
								<?php foreach ( $settings['tabs_2'] as $item ) : ?>
									<div class="grid-item">
										<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="grid-con">
											<?php if ( '' !== $item['tab_book'] ) : ?>
												<span class="book"><?php echo wp_kses_post($item['tab_book']); ?></span>
											<?php endif; ?>
											<span class="subtitle-title">
												<?php if ( '' !== $item['tab_subtitle'] ) : ?>
													<span class="subtitle"><?php echo wp_kses_post($item['tab_subtitle']); ?></span>
												<?php endif; ?>
												<?php if ( '' !== $item['tab_title'] ) : ?>
													<span class="title"><?php echo wp_kses_post($item['tab_title']); ?></span>
												<?php endif; ?>
											</span>
										</a>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
				<?php if  ( $settings['show_arrow_down'] ): ?>
				<!-- arrow down -->
				<div class="arrow bounce text-center">
					<a href="#" data-scroll-nav="1" class=""> <i class="ti-arrow-down"></i> </a>
				</div>
				<?php endif; ?>
			</div>
		
		<?php } ?>

		<?php if (is_admin())
		{ ?>
			<script type="text/javascript">
				(function () {
    var imageElements = document.querySelectorAll('.grid-img');
    var itemElements = document.querySelectorAll('.grid-con');
    if (itemElements.length) {
      itemElements.forEach(function (item, index) {
        item.addEventListener('mouseenter', function () {
          imageElements.forEach(function (image) {
            image.classList.remove('grid-img-active');
          });
          itemElements.forEach(function (card) {
            card.classList.remove('grid-con-active');
          });
          item.classList.add('grid-con-active');
          imageElements[index].classList.add('grid-img-active');
        });
      });
    }
  })();

// Slider Grid Background owlCarousel *
    $('.slider-grid-bg .owl-carousel').owlCarousel({
        loop: true,
        margin: 30,
        mouseDrag: true,
        autoplay: false,
        dots: true,
        nav: false,
        navText: ["<span class='lnr ti-angle-left'></span>","<span class='lnr ti-angle-right'></span>"],
        responsiveClass: true,
        responsive: {
            0: {
                items: 1,
                dots: true,
                nav: false
            },
            600: {
                items: 2,
                dots: true,
                nav: false
            },
            1000: {
                items: 3
            }
        }
    });
				
			</script>
		<?php }  ?>
	<?php
	}

}
